#!/bin/bash

CONTENTSTEX=$1
PDFLATEX=pdflatex

function doit {
   TEXFILE=$1
   BASENAMEEXT=$(echo $TEXFILE |sed -e 's/\.tex$//')
   BASENAMEEXT=$(echo $BASENAMEEXT |sed -e 's/^.*\(\-.*$\)/\1/')
   BASENAMEEXT=${BASENAME}${BASENAMEEXT}
   if [ -e $TEXFILE ]; then
   pdflatex --jobname=$BASENAMEEXT $TEXFILE
   pdflatex --jobname=$BASENAMEEXT $TEXFILE
else
   echo
   echo "WARNING: No existe el fichero $TEXFILE"
   echo "         NO se creará el archivo ${BASENAMEEXT}.pdf"
   echo
   read -p "         Presione ENTER para continuar..."
   echo
fi
} #de la funcion

function usage {
   echo
   echo "USO: $0 CONTENIDO.tex"
   echo "Donde CONTENIDO.tex es el nombre del archivo LaTeX de la presentación"
   echo "(sin la definición de \documentclass )"
   echo
} #de la funcion

if [ $# -ne 1 ]; then
   usage
   exit
fi

LINKTEX=presentacion-contents.tex
SCREENTEX=presentacion-screen.tex
PRINTTEX=presentacion-print.tex
NOTESONLYTEX=presentacion-notesonly.tex

if [ -e $LINKTEX ]; then
     echo
     echo "ERROR:"
     echo " Ya existe el fichero $LINKTEX"
     echo
     echo " Como internamente este script usa un link temporal"
     echo "que ha de llamarse ${LINKTEX}, no puede funcionar"
     echo "si ya existe cualquier tipo de archovo con este nombre."
     exit 1
fi

ln -s $CONTENTSTEX $LINKTEX

BASENAME=$(echo $CONTENTSTEX |sed -e 's/\.tex$//')

doit $SCREENTEX
doit $PRINTTEX
doit $NOTESONLYTEX

rm -f $LINKTEX &> /dev/null
rm -f *.out *.aux *.toc *.nav *.snm *.log &> /dev/null
